<?php
namespace App\Http\Controllers;

use DB;
use File;
use Response;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class DownloadController extends Controller {
	// Method index download template
	public function index() {

		return view('download');
		
	}

	// Method download
	public function download($filename) {

		// Ekpor filenya dulu
		$this->export();

		// Set file path
		$path = public_path().'/template/'.$filename;
		
		// Kalo ndak ada lempar not found
		if (!File::exists($path)) {
			abort(404);
		}
	
		// Balikin filenya
		$file = File::get($path);
		$type = File::mimeType($path);
		$response = Response::make($file, 200);
		$response->header("Content-Type", $type);

		return $response;
	}


	// Method buat export excel
	private function export() {

		// Data penerima
		$penerima = $this->dataPenerima();

		// Init spreadsheet broh
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();

		// Define default font dulu
		$spreadsheet->getDefaultStyle()->getFont()->setName('Roboto');
		$spreadsheet->getDefaultStyle()->getFont()->setSize(10);

		// Dibikin align center biar cantik
		$spreadsheet->getDefaultStyle()->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

		// Konten2 cellnya didefine dulu di awal
		$sheet->setCellValue('A1', "List Dokumen yang akan diupload");
		$sheet->setCellValue('A2', "");
		$sheet->setCellValue('A3', "No.");
		$sheet->setCellValue('B3', "Nomer Dokumen");
		$sheet->setCellValue('C3', "Nama Dokumen");
		$sheet->setCellValue('D3', "Deskripsi");
		$sheet->setCellValue('E3', "Ditujukan Kepada");

		// Bikin option dropdown
		$option = '';
		foreach($penerima as $val) {
			$option .= ', '.$val;
		}
		$option = substr($option, 2);		
		

		// Generate konten cell
		for($i=4;$i<29;$i++) {
			$sheet->setCellValue('A'.$i, ($i-3));
			// $sheet->setCellValue('B'.$i, "C - ".$i);
			// $sheet->setCellValue('C'.$i, "Dokumen Percelengan ".$i);
			// $sheet->setCellValue('D'.$i, "Dari celeng ".$i);

			$sheet->getCell('E'.$i)->getDataValidation()
				->setType(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST)
				->setAllowBlank(false)
				->setShowInputMessage(true)
				->setShowErrorMessage(true)
				->setShowDropDown(true)
				->setErrorTitle('Penerima tidak terdaftar.')
				->setError('Silahkan pilih dari daftar.')
				->setPromptTitle('Silahkan pilih dari daftar')
				->setPrompt('Silahkan pilih dari daftar.')
				->setFormula1('"'.$option.'"');
			$sheet->setCellValue('E'.$i, 'Silahkan pilih dari daftar ini');
		}

		// Set cell width
		for($i = 'B'; $i !== 'F'; $i++) {
			$calculatedWidth = $sheet->getColumnDimension($i)->getWidth();
			$sheet->getColumnDimension($i)->setWidth(36);
			$sheet->getColumnDimension($i)->setAutoSize(false);
		}

		// Merge cell buat titlenya
		$sheet->mergeCells('A1:E1');

		// Styling title dokumen
		$spreadsheet->getActiveSheet()->getStyle('A1')->applyFromArray($this->excelTitleStyle());

		// Styling header tablenya
		$spreadsheet->getActiveSheet()->getStyle('A3:E3')->applyFromArray($this->excelHeaderStyle());

		// Simpan dokumen
		$writer = new Xlsx($spreadsheet);
		if(!File::exists('template')) {
			File::makeDirectory('template', 0777, true, true);
			File::makeDirectory('uploaded', 0777, true, true);
		}
		$writer->save('template/list-dokumen.xlsx');

	}

	private function excelTitleStyle() {
		$style = [
			'font' => [
				'bold' => true,
				'size' => 16
			],
			'fill' => [
				'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR,
				'rotation' => 75,
				'startColor' => [
					'argb' => 'FF779FA1',
				],
				'endColor' => [
					'argb' => 'FFFFFFFF',
				],
			],
		];

		return $style;
	}

	private function excelHeaderStyle() {
		$style = [
			'font' => [
				'bold' => true
			],
			'fill' => [
				'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR,
				'rotation' => 75,
				'startColor' => [
					'argb' => 'FFFF6542',
				],
				'endColor' => [
					'argb' => 'FFFFFFFF',
				],
			],
		];

		return $style;
	}

	private function dataPenerima() {

		// Ambil data user dari db
		$result =  DB::table('users')
			->pluck('name')
			->toArray();

		return $result;		
	}

}
