<?php
namespace App\Http\Controllers;

use DB;
use Illuminate\Http\Request;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use App\Dokumen;

class UploadController extends Controller {

	// Method halaman index upload
	public function index() {

		return view('upload');
		
	}

	// Method buat save ke dybi
	public function saving(Request $request) {

		$counter = 0;
		foreach($request->id_staff_verifikator as $verifikator) {
			$document = [
				'title' => $request->title[$counter],
				'no_surat' => $request->no_surat[$counter],
				'deskripsi' => $request->deskripsi[$counter],
				'id_staff_verifikator' => $verifikator
			];
			if($docOp = Dokumen::create($document)) {
				$file = [
					'id_dokumen' => $docOp->id,
					'file_name' => $request->file_name[$counter],
					'path' => $request->path[$counter],
					'ext'=> $request->ext[$counter]
				];
			 	DB::table('file_dokumen')->insert($file);
			}
			$counter++;
		}

		return true;

	}

	// Method upload attachment
	public function attachment(Request $request) {

		// Validasi file yg diaplut
		$this->validate($request, [
			'file' => 'required | max:20000 | mimes:pdf,jpg,jpeg,PNG,JPG,JPEG,png,gif,bmp,doc,docx'
		]);

		// Mulai ngaplut file
		try {

			$file = $request->file('file');
			$filenameWithExt = $file->getClientOriginalName();
			$filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
			$extension = $file->getClientOriginalExtension();
			$fileNameToStore = date('YmdHis').md5($filename).'.'.$extension;
			$path = $file->storeAs('doc_attachment', $fileNameToStore);

			$filedata = [
				'file_name' => $fileNameToStore,
				'path' => $path,
				'ext'=> $extension
			];

			return response()->json(['status' => true, 'result' => $filedata]);

		} catch(Exception $e) {
			return response()->json(['status' => false]);
		}

	}

	// Method upload file-list
	public function upload(Request $request) {

		$result['status'] = false;

		$file = $request->file('file');
		try {

			$filename = $file->getClientOriginalName();
			$getExt = explode('.', $filename);
			$ext = strtolower(end($getExt));
			$timedName = date('YmdHis').md5($filename).'.'.$ext;

			if($file->move(public_path("/uploaded/"),$timedName)) {
				$result['status'] = true;
				$result['result'] = $this->read('./uploaded/'.$timedName);
			}

			return response()->json($result);

		} catch(Exception $e) {
			return response()->json($result);
		}
	}

	// Method baca file abis diaplut
	private function read($filename) {

		// Baca file dan ambil datanya
		$source = $this->readExcel($filename);

		// Iterate arraynya
		$input = [];
		foreach($source as $item) {
			if($item[1]!=''&&$item[2]!=''&&$item[4]!='Silahkan pilih dari daftar ini') {
				$fixed = $item;
				// Bandingkan nama user & ambil ID-nya
				if($id = $this->getUserIdByName($item[4])) {
					// Set inputnya
					$input[] = [
						'id_staff_verifikator' => $id,
						'no_surat' => $item[1],
						'title' => $item[2],
						'deskripsi' => $item[3],
						'verifikator' => $item[4]
					];
				} else {
					return ['status' => false, 'message' => 'Terdapat kesalahan input pada kolom penerima dokumen, silahkan cek kembali file yang anda input.'];
				}
			} elseif($item[1]!=''||$item[2]!=''||$item[4]!='Silahkan pilih dari daftar ini') {
				return ['status' => false, 'message' => 'Terdapat kesalahan input pada daftar dokumen, silahkan cek kembali file yang anda input.'];				
			}
		}

		return ['status' => true, 'data' => $input];

	}

	// Ambil user id dari nama
	private function getUserIdByName($name) {
		$result = DB::table('users')
			->select('id')
			->where('name', $name)
			->first();

		if($result!=null) {
			return $result->id;
		} else {
			return false;
		}
	}

	// Baca file excel
	private function readExcel($input) {

		// Check tipe filenya
		$inputType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($input);

		// Pilih readernya
		$reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputType);

		// Filenya dibaca
		$spreadsheet = $reader->load($input);

		// Dikonpret jadi array
		$result = $spreadsheet->getActiveSheet()->toArray();

		// Title sama headernya diremove
		array_splice($result, 0, 3);

		return $result;

	}

}
