<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>Laravel</title>

<!-- Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Nunito:wght@200;600&display=swap" rel="stylesheet">

<!-- Bootstrap CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css" integrity="sha384-zCbKRCUGaJDkqS1kPbPd7TveP5iyJE0EjAuZQTgFLD2ylzuqKfdKlfG/eSrtxUkn" crossorigin="anonymous">

<style type="text/css">
.file-container {
	min-width: 240px;
	max-width: 100%;
}
.file-group {
	position: relative;
	display: flex;
	width: 100%;
	height: 56px;
	border: 1px solid #bcbcbc;
	border-radius: 8px;
}
.file-group p {
	display: inline-block;
	width: 100%;
	margin: auto 0;
	padding: 0 72px 0 16px;
	font-size: 14px;
	color: #bcbcbc;
}
.file-group label {
	position: absolute;
	top: 0;
	right: 0;
	display: inline-block;
	width: 55px;
	height: 55px;
	border: none;
	background-image: url(../assets/img/blank.svg);
	background-size: 24px;
	background-repeat: no-repeat;
	background-position: center;
	cursor: pointer;
	border-left: 1px solid #bcbcbc;
}
.file-group input[type="file"] {
	display: none;
}
.file-group > span {
	width: auto;
	font-size: 10px;
}
.file-description {
	text-transform: uppercase;
}
</style>

</head>

<body class="bg-body bg-white">

	<!-- CONTENT GOES HERE	-->

	<div id="target-top" class="container-fluid">
		<div class="row">
			<!-- SIDE-NAV -->
			<nav id="sidebar" class="border-right mt-5 py-5 mt-md-2 pt-md-2 mt-lg-0 bg-light">
				<div class="sidebar-sticky">
					<h5 class="text-left text-dark my-sm-5 my-lg-2" style="letter-spacing: 2px;"><span class="	p-2 h2">Perbakin<span class="text-danger">DKI<span></span></span></span></h5>
					<div class="u-vmenu mt-lg-2 pb-5 pt-lg-4">
					</div>
						
				</div>
			</nav>
			<div class="sidebar-backdrop" data-toggle="sidebar"></div>

		
		<!-- END SIDE-NAV -->

		<!-- TOP-NAV -->
		<nav id="top-nav" class="fixed-top bg-transparent">
			<div class="navbar py-3 bg-white">
								
				<button id="btn-menu" class="btn btn-sm btn-menu text-primary">
					<i class="fa fa-bars"></i>
				</button>
								
				<div class="nav">
					<div class="nav-item dropdown mr-0 mx-md-3">
						<button data-toggle="dropdown" class="btn btn-sm rounded-circle bg-primary">
							<i class="fa fa-user text-white"></i>
						</button>
						<div>
						</div>
					</div>
				</div>
			</div>
		</nav>
		<!-- END TOP-NAV -->

		<main role="main" class="main pt-3 mt-3">
			<div class="app-content p-3 mt-4 p-md-4">
				<div class="container">
					<div class="row justify-content-center">
						<div class="col-lg-12">
							<div class="card">
								<div class="card-header d-flex justify-content-between">
									<h5>Batch Upload</h5>
								</div>

								<div class="card-body">
								<form action="#" method="POST" enctype="multipart/form-data" id="batch-upload-form">
									<input type="hidden" name="_token" value="jTwKa4VBnjLOsZRapzrKYM2JpR9Wxcip0ziYSjtF">
									<div class="file-group file-container">
										<p class="file-description">List Berkas</p>
										<label>
											<input type="file" name="file-list" data-name="list-berkas" id="file-list" />
											&nbsp;
										</label>
									</div>
									<div class="form-group">
										<small class="font-weight-bold"><i>Ekstensi : xls, xlsx</i></small>
									</div>
									<div class="d-flex justify-content-between">
										<button type="button" class="btn btn-primary" id="upload-list">Upload List</button>
									</div>
									<br/>
									<br/>
									<span id="file-upload-list"></span>
									<span id="save-message"></span>
									<div id="submit-button-container" class="d-flex justify-content-between">
										<button type="submit" class="btn btn-primary" id="save-data">Upload</button>
									</div>
								</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</main>
	</div>
	
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js" integrity="sha384-fQybjgWLrvvRgtW6bFlB7jaZrFsaBXjsOMm/tB9LTS58ONXgqbR9W8oWht/amnpF" crossorigin="anonymous"></script>

<script type="text/javascript">

$('body').on('click', '#upload-list', function(e) {

	let par = $('input[name="file-list"]').parents('label');
	e.preventDefault();
	let postData = new FormData();
	postData.append("_token", "{{ csrf_token() }}");
	postData.append("file", $('#file-list')[0].files[0]);
	$.ajax({
		url: "{{ url('/upload') }}",
		type: 'POST',
		data: postData,
		cache: false,
		processData: false,
		contentType: false,
		success: function(data, textStatus, jqXHR) {
			if(data.status&&data.result.status) {
				makeUploadField(data.result.data, $('#file-upload-list'));
				par.css('background-image', "url('./assets/img/success.svg')");
			} else {
				$('#file-upload-list').html('<p class="alert alert-danger text-danger">Terdapat kesalahan input daftar file yang diupload, silahkan cek lagi input anda.</p>');
				par.css('background-image', "url('./assets/img/error.svg')");
			}
		}, 
		error: function(jqXHR, textStatus, errorThrown) {
			$('#file-upload-list').html('<p class="alert alert-danger text-danger">Terdapat kesalahan saat upload, silahkan mengulang proses upload.</p>');
			par.css('background-image', "url('./assets/img/error.svg')");
		},
		complete: function (data) {
			$('#batch-upload-form')[0].reset();
		}
	});

});

function makeUploadField(data, container) {

	let content = '';
	for(i in data) {
		content = content+'<div class="file-group file-container">'+
			'<p class="file-description">No. Surat : '+data[i].no_surat+' <br/>Ditujukan Kepada : '+data[i].verifikator+'</p>'+
			'<label>'+
			'<input type="file" name="file[]" data-name="berkas" id="file" />'+
			'&nbsp;'+
			'</label>'+
			'</div>'+
			'<div class="form-group">'+
			'<input type="hidden" name="id_staff_verifikator[]" value="'+data[i].id_staff_verifikator+'" />'+
			'<input type="hidden" name="no_surat[]" value="'+data[i].no_surat+'" />'+
			'<input type="hidden" name="title[]" value="'+data[i].title+'" />'+
			'<input type="hidden" name="deskripsi[]" value="'+data[i].deskripsi+'" />'+
			'<input type="hidden" name="file_name[]" value="" />'+
			'<input type="hidden" name="path[]" value="" />'+
			'<input type="hidden" name="ext[]" value="" />'+
			'<small class="font-weight-bold"><i>Ekstensi : pdf, jpg, jpeg, png, gif, bmp, doc, docx</i></small>'+
			'</div>';
	}

	container.html(content);

}

$('body').on('change', 'input[name="file[]"]', function(e) {

	let par = $(this).parents('label');
	let container = $(this).parents('div.file-container');
	let pair = container.next('.form-group');
	let postData = new FormData();
	postData.append("_token", "{{ csrf_token() }}");
	postData.append("file", $(this)[0].files[0]);
	$.ajax({
		url: "{{ url('/upload-attachment') }}",
		type: 'POST',
		data: postData,
		cache: false,
		processData: false,
		contentType: false,
		success: function(data, textStatus, jqXHR) {
			par.css('background-image', "url('./assets/img/success.svg')");
			pair.find('input[name="file_name[]"]').val(data.result.file_name);
			pair.find('input[name="path[]"]').val(data.result.path);
			pair.find('input[name="ext[]"]').val(data.result.ext);
		}, 
		error: function(jqXHR, textStatus, errorThrown) {
			par.css('background-image', "url('./assets/img/error.svg')");
		},
		complete: function (data) {
			$('#batch-upload-form')[0].reset();
		}
	});

});

$('body').on('click', '#save-data', function(e) {

	e.preventDefault();
	let dataFields = $('#file-upload-list').find('input[type="hidden"]');
	let data = new FormData();
	let state = true;
	data.append("_token", "{{ csrf_token() }}");
	dataFields.each(function() {
		console.log($(this));
		data.append($(this).attr('name'), $(this).val());
		if($(this).val()=='') { state = false; }
	});
	if(state) {
		$.ajax({
			url: "{{ url('/save-data') }}",
			type: 'POST',
			data: data,
			cache: false,
			processData: false,
			contentType: false,
			success: function(data, textStatus, jqXHR) {
				$('#save-message').html('<p class="alert alert-success text-success">Proses telah selesai.</p>');
				$('#submit-button-container').html('');
			}, 
			error: function(jqXHR, textStatus, errorThrown) {
				$('#save-message').html('<p class="alert alert-danger text-danger">Terdapat kesalahan pada file yang diupload, silahkan cek lagi input anda.</p>');
			},
			complete: function (data) {
				$('#batch-upload-form')[0].reset();
			}
		});
	} else {
		alert('Terdapat file yang belum diupload/masih terdapat kesalahan pada file attachment. Silahkan periksa lagi file input anda.');
	}

});

</script>

</body>
</html>
